using System;
using System.Drawing;
using System.Data;
using System.Xml;
using System.Collections;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

//
namespace gov.va.med.vbecs.GUI
{
    /// <summary>
    /// Summary description for frmShipmentConfirm.
    /// </summary>
    public class DlgViewInvoice : gov.va.med.vbecs.GUI.VbecsBaseForm
    {
        private bool _confirmed;
        //
        private BOL.OutgoingShipmentCollection _invoice;
        //
        private System.Windows.Forms.Panel pnlInvoice;
        private System.Windows.Forms.Button btnBack;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvOutgoingShipment;
      
		/// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;
        
        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="invoice"></param>
        public DlgViewInvoice(BOL.OutgoingShipmentCollection invoice)
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
            //
            SetComponentProperties();
            //
            _invoice = invoice;
            this._confirmed = (_invoice.ShipmentDate != DateTime.MinValue);
            //
            vbecsLogo1.Title="Review Shipment Invoice";
            //
            this.SetupReport();
        }
		
		/// <summary>
		/// Destructor
		/// </summary>
		~DlgViewInvoice()
		{
			this.Dispose(true);
		}

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
					components = null;
                }
                System.Diagnostics.Debug.WriteLine(this.Name + " disposing.");
            }
            base.Dispose( disposing );
        }

		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DlgViewInvoice));
            this.btnBack = new System.Windows.Forms.Button();
            this.pnlInvoice = new System.Windows.Forms.Panel();
            this.rvOutgoingShipment = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlInvoice.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(736, 30);
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "View Invoice";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 479);
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnBack
            // 
            this.btnBack.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnBack.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnBack.Location = new System.Drawing.Point(652, 468);
            this.btnBack.Name = "btnBack";
            this.btnBack.Size = new System.Drawing.Size(75, 23);
            this.btnBack.TabIndex = 2;
            this.btnBack.Text = "&Close";
            // 
            // pnlInvoice
            // 
            this.pnlInvoice.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlInvoice.Controls.Add(this.rvOutgoingShipment);
            this.pnlInvoice.Location = new System.Drawing.Point(64, 36);
            this.pnlInvoice.Name = "pnlInvoice";
            this.pnlInvoice.Size = new System.Drawing.Size(664, 428);
            this.pnlInvoice.TabIndex = 0;
            // 
            // rvOutgoingShipment
            // 
            this.rvOutgoingShipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvOutgoingShipment.Location = new System.Drawing.Point(0, 1);
            this.rvOutgoingShipment.Name = "rvOutgoingShipment";
            this.rvOutgoingShipment.Size = new System.Drawing.Size(664, 427);
            this.rvOutgoingShipment.TabIndex = 0;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(56, 432);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 36;
            this.pictureBox1.TabStop = false;
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(572, 468);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // DlgViewInvoice
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnBack;
            this.ClientSize = new System.Drawing.Size(736, 493);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnBack);
            this.Controls.Add(this.pnlInvoice);
            this.hlphelpChm.SetHelpKeyword(this, "Outgoing_Shipment.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MinimumSize = new System.Drawing.Size(560, 520);
            this.Name = "DlgViewInvoice";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - View Invoice";
            this.Controls.SetChildIndex(this.pnlInvoice, 0);
            this.Controls.SetChildIndex(this.btnBack, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlInvoice.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

        private void SetComponentProperties()
        {
            vbecsLogo1.Title="Confirm Shipment";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = string.Concat(Environment.CurrentDirectory, "\\VBECS.chm");
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = string.Concat(Environment.CurrentDirectory, "\\VBECS.chm");
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC011.DlgViewInvoice());
            BOL.VbecsReport.SetUpReportButtons(this.rvOutgoingShipment);
        }
        //
        private void btnBack_Click(object sender, System.EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
        //
        private void SetupReport()
        {
			DataSet dsReport = _invoice.GetReportDataSet();
#if DEBUG
            //dsReport.Tables[0].WriteXml("e:\\temp\\OutgoingShipmentInvoiceDataSet.xml", XmlWriteMode.WriteSchema);
            //dsReport.Tables[1].WriteXml("e:\\temp\\OutgoingShipmentUnitsDataSet.xml", XmlWriteMode.WriteSchema);
#endif
            ReportDataSource reportSourceInvoice = new ReportDataSource();
            if (dsReport.Tables.Count > 0)
            {
                reportSourceInvoice.Name = "OutgoingShipmentInvoiceDataSet";
                reportSourceInvoice.Value = dsReport.Tables[0];
            }

            ReportDataSource reportSourceUnits = new ReportDataSource();
            if (dsReport.Tables.Count > 1)
            {
                reportSourceUnits.Name = "OutgoingShipmentUnitsDataSet";
                reportSourceUnits.Value = dsReport.Tables[1];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.OutgoingShipment.OutgoingShipmentInvoice.rdlc");

            this.rvOutgoingShipment.LocalReport.DataSources.Add(reportSourceInvoice);
            this.rvOutgoingShipment.LocalReport.DataSources.Add(reportSourceUnits);
            this.rvOutgoingShipment.LocalReport.LoadReportDefinition(stream);
            this.rvOutgoingShipment.RefreshReport();

        }
        //

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvOutgoingShipment.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

    }
}
